#ifdef WIN32

#include "MeetingAccountSDKWrapWin.h"
#include "jcfcoreutils/StringUtils.h"
#include "MeetingSiteStorager.h"
#include "sdkwrapper/win32/autoupgrade/jabber_sdk_wrap_impl.h"
#include "../MeetingServiceObjectManager.h"
#include "../cmr/CMRControllerMgr.h"


namespace CSFUnified {
    
	MeetingAccountSDKWrap::MeetingAccountSDKWrap()
	{
		m_maMgr = NULL;
	}

	MeetingAccountSDKWrap::~MeetingAccountSDKWrap()
	{
		m_maMgr = NULL;
	}

	MeetingAccountSDKWrap * MeetingAccountSDKWrap::getInstance()
	{
		static MeetingAccountSDKWrap * s_wrap = new MeetingAccountSDKWrap();
		if (NULL == s_wrap)
		{
			s_wrap = new MeetingAccountSDKWrap();
		}

		return s_wrap;
	}

	void MeetingAccountSDKWrap::start()
	{
		m_maMgr = JM_SDK_WRAP::JabberSDKWrapImpl::getInstance()->getIWbxMeetingAccountMgr();
		JM_SDK_WRAP::JabberSDKWrapImpl::getInstance()->setIWbxMeetingAccountObserve(this);
	}

	void MeetingAccountSDKWrap::stop()
	{
		JM_SDK_WRAP::JabberSDKWrapImpl::getInstance()->setIWbxMeetingAccountObserve(NULL);
		m_maMgr = NULL;
	}

	void MeetingAccountSDKWrap::verifyAccountWithPassword(std::string siteUrl, std::string userName, csf::SecureString userPass)
	{
		if (NULL != m_maMgr)
		{
			csf::SecureStringReader userPassReader;
			userPass.getUnsecureString(userPassReader);

			std::wstring siteUrl_w = JCFCoreUtils::toWideString(siteUrl);
			std::wstring userName_w = JCFCoreUtils::toWideString(userName);
			std::wstring userPass_w = JCFCoreUtils::toWideString(userPassReader.c_str());

			m_maMgr->VerifyAccount(siteUrl_w, userName_w, userPass_w, false);
			csf::SecureStringUtils::CSFZeroWstring(userPass_w);
		}
	}

	void MeetingAccountSDKWrap::verifyAccountWithSessionTicket(std::string siteUrl, std::string userName, std::string sessionTicket)
	{
		if (NULL != m_maMgr)
		{
			std::wstring siteUrl_w = JCFCoreUtils::toWideString(siteUrl);
			std::wstring userName_w = JCFCoreUtils::toWideString(userName);
			std::wstring userPass_w = JCFCoreUtils::toWideString(sessionTicket);

			m_maMgr->VerifyAccount(siteUrl_w, userName_w, userPass_w, true);
		}
	}
    
    void MeetingAccountSDKWrap::deleteDefaultAccount()
    {
        if (NULL != m_maMgr)
        {
            m_maMgr->SetAccountEmpty();
        }
        
        CMRControllerMgr * pMgr = MeetingServiceObjectManager::getInstance().getCMRMgr();
        if (NULL != pMgr)
        {
            CMRProperty property;
            pMgr->onPMRPropertyChange(true, false, property);
        }
    }


	void MeetingAccountSDKWrap::checkSSOSite(std::string siteUrl)
	{
		if (NULL != m_maMgr)
		{
			std::wstring siteUrl_w = JCFCoreUtils::toWideString(siteUrl);
			m_maMgr->CheckSiteSSOFlag(siteUrl_w);
		}
	}

	void MeetingAccountSDKWrap::checkSSOSiteList(std::list<std::string> siteList)
	{
		if (NULL != m_maMgr)
		{
			std::string siteUrlList = "";
			std::list<std::string>::iterator it = siteList.begin();
			while (it != siteList.end())
			{
				siteUrlList += "<";
				siteUrlList += (*it);
				siteUrlList += ">";
				it++;
			}

			std::wstring siteUrlList_w = JCFCoreUtils::toWideString(siteUrlList);
			m_maMgr->CheckSSOSiteList(siteUrlList_w);
		}
	}

	int MeetingAccountSDKWrap::isSSOSite(std::string siteUrl)
	{
		if (NULL != m_maMgr)
		{
			std::wstring siteUrl_w = JCFCoreUtils::toWideString(siteUrl);
			return m_maMgr->GetSiteSSOFlag(siteUrl_w);
		}

		return 0; 
	}
   
	void MeetingAccountSDKWrap::OnVerifyAccount(bool bSuccess, TWBXMeetingAccountInfo * pAccount, JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode)
	{
		if (!bSuccess)
		{
			int errorCode = eErrCode;
			MeetingSiteStorager::getInstance()->onVerifyAccount(false, errorCode, 0, "", 0);
		}
		else
		{
            m_maMgr->SetActiveAccount(*pAccount);

            int siteType = pAccount->eSiteFlag;
			std::string sessionTicket = JCFCoreUtils::toString(pAccount->strSessionTicket);
			MeetingSiteStorager::getInstance()->onVerifyAccount(true, 0, siteType, sessionTicket, 0);
            
            CMRControllerMgr * pMgr = MeetingServiceObjectManager::getInstance().getCMRMgr();
            if (NULL != pMgr)
            {
                CMRProperty property;
				property.isCMR = pAccount->bIsEnableCET;
				property.isPMR = pAccount->bApplyPMRForInstantMeeting;
				property.fixedSipUrl = JCFCoreUtils::toString(pAccount->strSipURL);
				property.fixedHostPin = JCFCoreUtils::toString(pAccount->strHostPIN);
				property.fixedJoinUrl = JCFCoreUtils::toString(pAccount->strPersonalMeetingRoomURL);
				property.siteUrl = JCFCoreUtils::toString(pAccount->strSiteURL);
				property.siteName = JCFCoreUtils::toString(pAccount->strSiteName);
				property.fixedMeetingKey = JCFCoreUtils::toString(pAccount->strPersonalMeetingRoomKey);
				property.fixedAccessCode = JCFCoreUtils::toString(pAccount->strPersonalMeetingRoomKey);
                pMgr->onPMRPropertyChange(true, property.isCMR, property);
            }
		}
	}

	void MeetingAccountSDKWrap::OnNoticeActiveAccountChange(bool bExistActiveAccount)
	{
		NULL;
	}

	void MeetingAccountSDKWrap::OnNoticeSessionTicketRefreshed(const std::wstring& strSessionTicket)
	{
		NULL;
	}

	void MeetingAccountSDKWrap::OnNoticeInvalidCertInMeetingSite(JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode)
	{
		int errorCode = eErrCode;
		MeetingSiteStorager::getInstance()->onVerifyAccount(false, errorCode, 0, "", 0);
	}

	void MeetingAccountSDKWrap::OnCheckSSOSiteListReady()
	{
		MeetingSiteStorager::getInstance()->onCheckSiteListSSOInfo();
	}

	void MeetingAccountSDKWrap::OnCheckSiteSSOFlagReady(const wstring& strSiteUrl, E_WBX_SITE_SSO_FLAG flag)
	{
		std::string url = JCFCoreUtils::toString(strSiteUrl);
		MeetingSiteStorager::getInstance()->onCheckSSOSite(flag, url);
	}

}

#endif
